<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = '_menu';
        $this->shcontrollname = 'لوحه القائمه';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'managment'; //controller name or tab name
        $active[1] = 'menu'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'menuadd';
                break;
            case 'show':$active[2] = 'menushow';
                break;
            default :$active[2] = 'menushow';
                break;
        }
        $this->active = $active;


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //load all parents here
        $menus = R::findAll('awmenu');
        $this->smarty->assign('menus', $menus);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('_menu/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $label = filter_input(INPUT_POST, 'label');
        $link = filter_input(INPUT_POST, 'link');
        $parent = filter_input(INPUT_POST, 'parent');
        $icon = filter_input(INPUT_POST, 'menuicon');
        $activename = filter_input(INPUT_POST, 'activename');


        //here the add
        $menu = R::dispense('awmenu');
        $menu->label = $label;
        $menu->link = $link;
        $menu->parent = $parent;
        $menu->sort = 1;
        $menu->icon = $icon;
        $menu->activeName = $activename;

        try {
            $id = R::store($menu);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //here will load the menu show
        $dismenu = $this->displaymenush(0, $this->hosturl);

        $this->smarty->assign('dismenu', $dismenu);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('_menu/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    //just use it to draw menu
    public function displaymenush($parent, $hosturl) {

        $menuhtml = "";
        //get the all about this level in menu
        //dd-handle dd3-handle
        $result = R::getAll('SELECT a.*, Deriv1.count FROM `awmenu` a  LEFT OUTER JOIN (SELECT parent, COUNT(*) AS Count FROM `awmenu` GROUP BY parent) Deriv1 ON a.id = Deriv1.parent WHERE a.parent= ?', [ $parent]);

        foreach ($result as $srel) {

            if ($srel['count'] > 0) {
                $menuhtml .= '<li class="dd-item dd3-item" data-id="' . $srel["id"] . '">';
                $menuhtml .= '<div class=""></div><div class="dd3-content">'
                        . '<i class="' . $srel["icon"] . '"></i> '
                        . $srel["label"]
                        . '<a data-id="' . $srel["id"] . '" data-link="_menu" class="btn grey-cascade btn-xs pull-right deletemsg mg_top"><i class="fa fa-times"></i> حذف</a>'
                        . '<a href="' . $hosturl . '/_menu/edit/' . $srel["id"] . '" class="btn blue-hoki btn-xs pull-right mg-rg mg_top"><i class="fa fa-pencil"></i> تعديل</a>'
                        . '</div>';
                $menuhtml .= '<ol class="dd-list">'
                        . $this->displaymenush($srel["id"], $hosturl)
                        . '</ol>'
                        . '</li>';
            } elseif ($srel['count'] == 0) {
                $menuhtml .= '<li class="dd-item dd3-item" data-id="' . $srel["id"] . '">';
                $menuhtml .= '<div class=""></div><div class="dd3-content">'
                        . '<i class="' . $srel["icon"] . '"></i> '
                        . $srel["label"]
                        . '<a data-id="' . $srel["id"] . '" data-link="_menu" class="btn grey-cascade btn-xs pull-right deletemsg mg_top"><i class="fa fa-times"></i> حذف</a>'
                        . '<a href="' . $hosturl . '/_menu/edit/' . $srel["id"] . '" class="btn blue-hoki btn-xs pull-right mg-rg mg_top"><i class="fa fa-pencil"></i> تعديل</a>'
                        . '</div>';
                $menuhtml .= '</li>';
            }
        }
        return $menuhtml;
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all parents here
        $menus = R::findAll('awmenu');
        $this->smarty->assign('menus', $menus);

        //load all parents here
        $menu = R::load('awmenu', $itemid);
        $this->smarty->assign('menu', $menu);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('_menu/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $label = filter_input(INPUT_POST, 'label');
        $link = filter_input(INPUT_POST, 'link');
        $parent = filter_input(INPUT_POST, 'parent');
        $icon = filter_input(INPUT_POST, 'menuicon');
        $activename = filter_input(INPUT_POST, 'activename');
        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $menu = R::load('awmenu', $id);

        //here the upadte
        $menu->label = $label;
        $menu->link = $link;
        $menu->parent = $parent;
        $menu->sort = 1;
        $menu->icon = $icon;
        $menu->activeName = $activename;


        try {
            R::store($menu);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');


        //load all item here
        $menu = R::load('awmenu', $itemid);

        $undermenu = R::count('awmenu', ' parent = ? ', [ $itemid]);
        if ($undermenu > 0) {
            header('Location:' . $this->hosturl . '/error/relate/' . $this->controllname);
            exit();
        }

        //check in role menu
        $rolemenu = R::count('awrolemenu', ' menu_id = ? ', [ $itemid]);
        if ($rolemenu > 0) {
            //header('Location:' . $this->hosturl . '/error/relate/' . $this->controllname);
            //exit();
            $rolemenuin = R::findAll('awrolemenu', ' menu_id = ? ', [ $itemid]);
            R::trashAll($rolemenuin);
        }

        try {

            R::trash($menu);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
