<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    //menu itr for input
    public $menuitr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions

        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'm_articals';
        $this->shcontrollname = 'المقالات';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'appsetting'; //controller name or tab name
        $active[1] = 'pageshow'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'pageadd';
                break;
            case 'show':$active[2] = 'pageshow';
                break;
            default :$active[2] = 'pageshow';
                break;
        }
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //here will load the caftria show
        //$caftrias = R::findAll('caftria', 'order by id desc');
        $cats = R::findAll('cats', 'order by id desc');
        $this->smarty->assign('cats', $cats);

        //# select all colors ;
        $colors = R::findAll('colors', 'order by id ASC');
        $colorTxt = '';
        foreach ($colors as $value) {
            $colorTxt .= ',' . $value['name'];
        }
        $colorTxt = trim($colorTxt, ',');
        $this->smarty->assign('colorTxt', $colorTxt);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('m_articals/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $articalName = filter_input(INPUT_POST, 'articalName');
        $articalCat = filter_input(INPUT_POST, 'articalCat');
        $img = uploadnew('image', False, 0, 0, 'm_articals');


        $audioTalker = filter_input(INPUT_POST, 'audioTalker');
//        $audioVoice = filter_input(INPUT_POST, 'audioVoice');
        $audioVoice = uploadnew('audioVoice', False, 0, 0, 'm_articals');
        $mainTxt = filter_input(INPUT_POST, 'mainTxt');
        $mainTxtContent = filter_input(INPUT_POST, 'mainTxtContent');
        $mainTxt2 = filter_input(INPUT_POST, 'mainTxt2');
        $mainTxtContent2 = filter_input(INPUT_POST, 'mainTxtContent2');

        //here the add
        $page = R::dispense('articals');
        $page->artical_name = $articalName;
        $page->artical_cat = $articalCat;
        $page->img = $img;
        $page->audio_talker = $audioTalker;
        $page->audio_voice = $audioVoice;
        $page->main_txt = $mainTxt;
        $page->main_txt_content = $mainTxtContent;
        $page->main_txt2 = $mainTxt2;
        $page->maintxtcontent2 = $mainTxtContent2;

        try {
            $id = R::store($page);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //here will load the caftrias show
        $articals = R::findAll('articals', 'order by id desc');
        $this->smarty->assign('articals', $articals);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('m_articals/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //# select all colors ;
        $colors = R::findAll('colors', 'order by id ASC');
        $colorTxt = '';
        foreach ($colors as $value) {
            $colorTxt .= ',' . $value['name'];
        }
        $colorTxt = trim($colorTxt, ',');
        $this->smarty->assign('colorTxt', $colorTxt);

        //# select all caftrias .
        $cats = R::findAll('cats', 'order by id desc');
        $this->smarty->assign('cats', $cats);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all here
        $artical = R::load('articals', $itemid);
        $this->smarty->assign('artical', $artical);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('m_articals/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $articalName = filter_input(INPUT_POST, 'articalName');
        $articalCat = filter_input(INPUT_POST, 'articalCat');
        $img = uploadupdate('image', 'imageurl', False, 0, 0, 'm_articals');


        $audioTalker = filter_input(INPUT_POST, 'audioTalker');
//        $audioVoice = filter_input(INPUT_POST, 'audioVoice');
        $audioVoice = uploadupdate('audioVoice', 'oldAudio', False, 0, 0, 'm_articals');
        $mainTxt = filter_input(INPUT_POST, 'mainTxt');
        $mainTxtContent = filter_input(INPUT_POST, 'mainTxtContent');
        $mainTxt2 = filter_input(INPUT_POST, 'mainTxt2');
        $mainTxtContent2 = filter_input(INPUT_POST, 'mainTxtContent2');
        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $page = R::load('articals', $id);

        //here the upadte
        $page->artical_name = $articalName;
        $page->artical_cat = $articalCat;
        $page->img = $img;

        $page->audio_talker = $audioTalker;
        $page->audio_voice = $audioVoice;
        $page->main_txt = $mainTxt;
        $page->main_txt_content = $mainTxtContent;
        $page->main_txt2 = $mainTxt2;
        $page->maintxtcontent2 = $mainTxtContent2;
        try {
            R::store($page);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all item here
        $page = R::load('articals', $itemid);

        try {

            R::trash($page);

            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
