<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'm_colors';
        $this->shcontrollname = 'الالوان';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'managment'; //controller name or tab name
        $active[1] = 'member'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'memberadd';
                break;
            case 'show':$active[2] = 'membershow';
                break;
            default :$active[2] = 'membershow';
                break;
        }
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");

        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //load all parents here
        $roles = R::findAll('awrole');
        $this->smarty->assign('roles', $roles);

        $colors = R::findAll('colors', 'order by id ASC');

        $countColors = R::count('colors');
        if ($countColors == '') {
            $countColors = 1;
            $colors = array('name' => 'AB0000');
        }
        $this->smarty->assign('countColors', $countColors);
        $this->smarty->assign('colors', $colors);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('m_colors/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $rowItra = filter_input(INPUT_POST, 'rowItra');

        //# remove all colors .
        R::exec('delete from colors');
        try {
            for ($i = 1; $i <= $rowItra; $i++) {
                $name = filter_input(INPUT_POST, 'name_' . $i . '');
                if ($name != '') {
                    $colors = R::dispense('colors');
                    $colors->name = $name;
                    //here the add
                    R::store($colors);
                }
            }

            header('Location:' . $this->hosturl . '/' . $this->controllname);
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
