<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    //menu itr for input
    public $menuitr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions

        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'page';
        $this->shcontrollname = ' الصفحات';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'appsetting'; //controller name or tab name
        $active[1] = 'pageshow'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'pageadd';
                break;
            case 'show':$active[2] = 'pageshow';
                break;
            default :$active[2] = 'pageshow';
                break;
        }
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $page = R::findAll('page');
        $this->smarty->assign('page', $page);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('page/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);



        //vars here
        $name_ar = filter_input(INPUT_POST, 'name_ar');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $content_ar = filter_input(INPUT_POST, 'content_ar');
        $content_en = filter_input(INPUT_POST, 'content_en');
        $order = filter_input(INPUT_POST, 'order');
        $parent = filter_input(INPUT_POST, 'parent');
        $image = uploadnew('file', False, 0, 0, 'page');

        $type = filter_input(INPUT_POST, 'typeshow');
        $link = filter_input(INPUT_POST, 'link');
        //here the add
        $page = R::dispense('page');
        $page->name = $name_ar;
        $page->name_en = $name_en;
        $page->content_en = $content_en;
        $page->content = $content_ar;
        $page->order = $order;
        $page->parent = $parent;
        $page->image = $image;
        $page->type = $type;
        $page->link = $link;



        try {
            R::store($page);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //here will load the menu show
        $pages = R::findAll('page', 'order by id desc');
        $this->smarty->assign('pages', $pages);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('page/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        $pages = R::findAll('page');
        $this->smarty->assign('pages', $pages);
        //load all here
        $page = R::load('page', $itemid);
        $this->smarty->assign('page', $page);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('page/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name_ar = filter_input(INPUT_POST, 'name_ar');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $content_ar = filter_input(INPUT_POST, 'content_ar');
        $content_en = filter_input(INPUT_POST, 'content_en');
        $order = filter_input(INPUT_POST, 'order');
        $parent = filter_input(INPUT_POST, 'parent');
        $image = uploadupdate('image1', 'imageurl1', False, 0, 0, 'page');

        $type = filter_input(INPUT_POST, 'typeshow');
        $link = filter_input(INPUT_POST, 'link');

        $id = filter_input(INPUT_POST, 'id');

        //R::debug( TRUE );
        //load all parents here
        $page = R::load('page', $id);

        //here the upadte
        $page->name = $name_ar;
        $page->name_en = $name_en;

        $page->content = $content_ar;
        $page->content_en = $content_en;
        $page->order = $order;
        $page->parent = $parent;
        $page->image = $image;
        $page->type = $type;
        $page->link = $link;
        R::store($page);

        header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all item here
        $page = R::load('page', $itemid);

        try {
            if ($itemid > 3) {
                R::trash($page);
            }
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function deleteselected() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        foreach ($deleteidsArray as $id) {
            $page = R::load('page', $id);
            if (file_exists('../../upload/' . $this->controllname . '/' . $page->image)) {
                //echo $imageNewName;
                chmod('../../upload/' . $this->controllname . '/' . $page->image, 0777);
                unlink('../../upload/' . $this->controllname . '/' . $page->image);
            }
            if ($id > 3) {
                R::trash($page);
                echo 1;
            } else
                echo -1;
        }
    }

    public function check() {

//check login
        autho::checkautho($this->hosturl);
//check authoize
//autho::checkauthoize($this->controllname,$this->hosturl,$_SESSION['role_id']);

        $name = filter_input(INPUT_POST, 'datainput');
        $name_en = filter_input(INPUT_POST, 'data_en');
// $name_en = filter_input(INPUT_POST, 'name_en');
        $checkedit = filter_input(INPUT_POST, 'edit');

        if (!empty($name)) {
            if (!$checkedit) {
//new
                $checkname = R::getRow('SELECT * FROM page WHERE name= ? LIMIT 1', [$name]);

                if (count($checkname) > 0) {
                    echo "yes";
                } else {
                    echo "no";
                }
            } else {

//edit
                $checkname = R::getRow('SELECT * FROM page WHERE name=? LIMIT 1', [$name]);

                if (count($checkname) > 0) {
                    if ($checkedit == $checkname['name']) {
                        echo "no";
                    } else {
                        echo "yes";
                    }
                } else {
                    echo "no";
                }
            }
        }
    }

    public function hide() {


        //get id for item
        $itemid = filter_input(INPUT_POST, 'itemid');
        $ishide = filter_input(INPUT_POST, 'ishide');

        //load all item here
        $page = R::load('page', $itemid);

        $page->hide = $ishide;


        try {
            R::store($page);

            //change the button
            echo '1';
        } catch (Exception $e) {
            echo '0';
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
