<?php

/**
 *
 * @Create Breadcrumbs Trail.
 *
 * @copyright Copyright (C) 2008 PHPRO.ORG. All rights reserved.
 *
 * @version //autogentag//
 *
 * @license new bsd http://www.opensource.org/licenses/bsd-license.php
 *
 * @filesource
 *
 * @package Breadcrumbs
 *
 * @Author Kevin Waterson
 *
 */
class breadcrumbs {
    /*
     * @string $breadcrumbs
     */

    public $breadcrumbs;

    /*
     * @string $pointer
     */
    private $pointer = '<i class="fa fa-angle-right"></i>';

    /*
     * @string $url
     */
    private $url;

    /*
     * @array $parts
     */
    private $parts;
    private $linqurl;
    private $controllname;
    private $shownname;
    private $doaction;

    /*
     * @constructor - duh
     *
     * @access public
     *
     */

    public function __construct($hosturl, $controllname, $shownname, $do) {
        $this->setParts();
        $this->linqurl = $hosturl;
        $this->controllname = $controllname;
        $this->shownname = $shownname;
        $this->doaction = $do;
        $this->setURL();
        /* $this->breadcrumbs = '<li><a href="' . $this->url . '">الرئيسية</a></li>'; */
        $this->breadcrumbs = '<li><i class="fa fa-home"></i><a href="' . $this->url . '">الرئيسيه</a><i class="fa fa-angle-left"></i></li>';
    }

    /*
     *
     * @set the base url
     *
     * @access private
     *
     */

    private function setURL() {
        $protocol = $_SERVER["SERVER_PROTOCOL"] == 'HTTP/1.1' ? 'http' : 'https';

        //$this->url = $this->linqurl . '/admin';
        $this->url = $this->linqurl; //$this->url = $this->linqurl.'/admin';
    }

    /*
     * @set the pointer
     *
     * @access public
     *
     * @param string $pointer
     *
     */

    public function setPointer($pointer) {
        $this->pointer = $pointer;
    }

    /**
     *
     * @set the path array
     *
     * @access private
     *
     * @return array
     *
     */
    private function setParts() {
        $parts = explode('/', $_SERVER['REQUEST_URI']);

        //array_pop($parts);
        array_shift($parts);
        array_shift($parts);
        array_shift($parts);
        array_shift($parts);
        $this->parts = $parts;
    }

    /**
     *
     * @create the breadcrumbs
     *
     * @access public
     *
     */
    public function crumbs() {
        foreach ($this->parts as $part) {
            $this->url .= "/$part";
            if ($part == $this->controllname && $this->controllname != '') {
                //$this->breadcrumbs .= '<li><a href="' . $this->url . '/show">' . $this->shownname . '</a></li>';
                $this->breadcrumbs .= '<li><a href="' . $this->url . '/show">' . $this->shownname . '</a>' . $this->pointer . '</li>';
                if (empty($this->doaction)) {
                    $this->breadcrumbs .= '<li class="last"> اضافه جديد</li>';
                }
            } else {
                if ($part == 'edit') {
                    $this->breadcrumbs .= '<li> تعديل العنصر</li>';
                } elseif ($part == 'show') {
                    $this->breadcrumbs .= '<li> عرض البيانات</li>';
                } elseif ($part == 'info') {
                    $this->breadcrumbs .= '<li> بياناتى</li>';
                } elseif ($part == 'setting') {
                    $this->breadcrumbs .= '<li> اعدادات</li>';
                }
            }
        }
    }

}

/* * * end of class ** */
?>